/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: WatchdogDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 26.03.07 16:13 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Watchdog trigger dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file WatchdogDlg.cpp
///   Watchdog trigger dialog
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "WatchdogDlg.h"
#include "CifxTestDlg.h"
#include ".\watchdogdlg.h"


#define DEFAULT_WATCHDOG_TIMEOUT  500

IMPLEMENT_DYNAMIC(CWatchdogDlg, CBaseDialog)

static int iTest = 0;

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CWatchdogDlg::CWatchdogDlg(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CWatchdogDlg::IDD, pParent, true, DEFAULT_WATCHDOG_TIMEOUT)
  , m_ulLastTriggerValue(0)
  , m_fTriggerWatchdog(false)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CWatchdogDlg::~CWatchdogDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV Support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CWatchdogDlg::DoDataExchange(CDataExchange* pDX)
{
	CBaseDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CWatchdogDlg, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_STARTSTOP, OnBnClickedBtnStartstop)
  ON_EN_KILLFOCUS(IDC_EDT_TRIGGERINTERVAL, OnEnKillfocusEdtTriggerinterval)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// First time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CWatchdogDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TRIGGERINTERVAL, m_ulThreadTimeout,    FALSE);
  SetDlgItemInt(IDC_EDT_WATCHDOGVALUE,   m_ulLastTriggerValue, FALSE);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Start/Stop Button clicked event
/////////////////////////////////////////////////////////////////////////////
void CWatchdogDlg::OnBnClickedBtnStartstop()
{
  m_fTriggerWatchdog = !m_fTriggerWatchdog;

  if(m_fTriggerWatchdog)
  {
    SetDlgItemText(IDC_BTN_STARTSTOP, _T("&Stop Watchdog"));

  } else
  {
    SetDlgItemText(IDC_BTN_STARTSTOP, _T("&Start Watchdog"));

    // Stop watchdog on device, to prevent device stop
    int32_t lWatchdogError = CcifXTestDlg::s_pcDevice->Watchdog(CIFX_WATCHDOG_STOP, &m_ulLastTriggerValue);
    
    // Display 0 for Watchdog Value
    SetDlgItemInt(IDC_EDT_WATCHDOGVALUE, 0, FALSE);    

    VERIFY(CIFX_NO_ERROR == lWatchdogError);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Thread function to cyclically trigger the channel's watchdog
/////////////////////////////////////////////////////////////////////////////
void CWatchdogDlg::ThreadFunction()
{
  if(m_fTriggerWatchdog)
  {
    if(CcifXTestDlg::s_pcDevice)
    {
      long lWatchdogError = CcifXTestDlg::s_pcDevice->Watchdog(CIFX_WATCHDOG_START, &m_ulLastTriggerValue);

      SetDlgItemInt(IDC_EDT_WATCHDOGVALUE, m_ulLastTriggerValue, FALSE);

      CString csTemp;

      if(CIFX_NO_ERROR != lWatchdogError)
        csTemp.Format(_T("0x%08X\r\n%s"),
                      lWatchdogError,
                      (LPCSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lWatchdogError));

      SetDlgItemText(IDC_LASTERR, csTemp);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Device changed in main dialog event
///   \param pcDevice new Device object (NULL if no device open)
/////////////////////////////////////////////////////////////////////////////
void CWatchdogDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  if(NULL == pcDevice)
  {
    //stop watchdog on device, to prevent device stop
    long lWatchdogError = CcifXTestDlg::s_pcDevice->Watchdog(CIFX_WATCHDOG_STOP, &m_ulLastTriggerValue);

    VERIFY(CIFX_NO_ERROR == lWatchdogError);

  } else
  {
    //restart watchdog on device if it was active before, This is automatically done by thread
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Watchdog triggering interval changed event
/////////////////////////////////////////////////////////////////////////////
void CWatchdogDlg::OnEnKillfocusEdtTriggerinterval()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TRIGGERINTERVAL, csTemp);

  TCHAR* pszEnd = NULL;
  unsigned long ulTimeout = _tcstoul(csTemp, &pszEnd, 10);

  SetThreadTimeout(ulTimeout);

  csTemp.Format(_T("%u"), ulTimeout);
  SetDlgItemText(IDC_EDT_TRIGGERINTERVAL, csTemp);
}
